#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
const long long DIM = 1e4 + 7, INF = 1e9 + 7;

string s;
int sz;

enum verdict_type
{
  error,
  valid,
  enclosed
};

struct verdict
{
  verdict_type data;
  int i;

  verdict(verdict_type d)
  {
    data = d;
  }

  verdict(verdict_type d, int _i)
  {
    data = d, i = _i;
  }
};

verdict checker(int pos, string root)
{
  string tagname;
  int i = pos;
  bool to_be_enclosed = false;

  if (i >= sz)
    return verdict(error);

  if (s[i] != '<')
    return verdict(error);

  i++;

  if (s[i] == '/')
  {
    to_be_enclosed = true, i++;
    if (root == "")
      return verdict(error);
  }

  for (; s[i] != '>'; i++)
  {
    if (i + 1 == sz)
      return verdict(error);
    tagname += s[i];
  }

  if (to_be_enclosed)
    return verdict(tagname == root ? enclosed : error, i);

  i++;

  while (true)
  {
    verdict next = checker(i, tagname);
    if (next.data == error)
      return verdict(error);
    if (next.data == enclosed)
      return verdict(valid, next.i);
    i = next.i + 1;
  }
}

int main()
{
  ios_base::sync_with_stdio(0), cin.tie(0), cout.tie(0);
  //freopen("./input.txt", "r", stdin);

  cin >> s;
  sz = s.size();
  s += "     ";

  int i = 0;
  while (true)
  {
    verdict next = checker(i, "");
    if (next.data == error)
    {
      cout << "No\n";
      return 0;
    }
    if (next.i == sz - 1)
    {
      cout << "Yes\n";
      return 0;
    }
    i = next.i + 1;
  }

  return 0;
}
